set sql_safe_updates=0;

-- Parent Login Creation

SET @plcDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `parents` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T2.id
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T2.id IN (namedParams) AND ual.whetherPrimary = TRUE" WHERE `dataProviderId` = @plcDT;

    
    
SET @plcTemConf=(SELECT id FROM msg_template_config WHERE `code`='Parent Login Creation Template');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body data-gramm="true" data-gramm_editor="true" data-gramm_id="6037d60b-9557-ccb5-a484-7241c8b12961">
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">You can Login to Academia&nbsp;with following credential</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @plcTemConf and msgDeliveryModeId in (1,4);


-- Parent Forget Password

SET @pfpTemConf=(SELECT id FROM msg_template_config WHERE `code`='Parent Forget Password Template');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<p>&nbsp;</p>

<p>&nbsp;</p>

<p><br />
<title></title>
</p>

<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your new Login credentials are as follows</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @pfpTemConf and msgDeliveryModeId in (1,4);


-- Forget Pasword

SET @fpDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    `fire_base_persons_info` f ON f.`userId` = T1.`userId`
		LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T2.id
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T2.id IN (namedParams) AND ual.whetherPrimary = TRUE
GROUP BY T1.userId" WHERE `dataProviderId` = @fpDT;
    
SET @fpTemConf=(SELECT id FROM msg_template_config WHERE `code`='FORGET_PASSWORD');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your new credentials are as below:<br />
			<br />
			User Name: <strong>$templateData[&quot;CODE&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong><br />
			&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @fpTemConf and msgDeliveryModeId in (1,4);




-- Student Forget Password

SET @sfpDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
	(CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `students` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        INNER JOIN
    `admission` adm ON adm.studentId = T2.`id`
        INNER JOIN
    `academy_location` al ON al.id = adm.academyLocationId
        INNER JOIN
    `program_batch_students` pbs ON pbs.admissionId = adm.id
        LEFT JOIN
    `organizations` org ON org.id = 1
        LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T2.id
WHERE
    T2.id IN (namedParams)
        AND adm.activeStatus = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL
GROUP BY T2.id" WHERE `dataProviderId` = @sfpDT;
    
SET @sfpTemConf=(SELECT id FROM msg_template_config WHERE `code`='Student Forget Password Template');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your new Login credentials are as follows</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @sfpTemConf and msgDeliveryModeId in (1,4);

-- Service Request Follow Up Assign

SET @srfaDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_FOLLOWUP_ASSIGN_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T7.id AS ID,
    T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    (CASE WHEN T6.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN T6.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T6.logoUrl) END) AS LOGO_URL
FROM
    followup_details T7
        LEFT JOIN
    service_requests T1 ON T1.id = T7.serviceRequestId
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T7.assigneeUserId
        LEFT JOIN
    staffs T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T7.id IN (namedParams)" WHERE `dataProviderId` = @srfaDT;
    
SET @srfaTemConf=(SELECT id FROM msg_template_config WHERE `code`='Service Request Follow Up Assign');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Service Request for $recipientData[&quot;REQUEST_TYPE&quot;] with request number $recipientData[&quot;REQUEST_ID&quot;] is assigned to you.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @srfaTemConf and msgDeliveryModeId in (1,4);

-- Service Request Student Creation

SET @srscDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_STUDENT_CREATION_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
	T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
	(CASE WHEN T6.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN T6.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T6.logoUrl) END) AS LOGO_URL
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.requester
        INNER JOIN
    students T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
		LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId` = @srscDT;
    
SET @srscTemConf=(SELECT id FROM msg_template_config WHERE `code`='Service Request Student Transfer Creation');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Your request for $recipientData[&quot;REQUEST_TYPE&quot;] is created with request number $recipientData[&quot;REQUEST_ID&quot;]. The Administrator will contact you shortly.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @srscTemConf and msgDeliveryModeId in (1,4);


-- Service Request Parent Creation


SET @srpcDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_PARENT_CREATION_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
	(CASE WHEN T6.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN T6.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T6.logoUrl) END) AS LOGO_URL
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.parentsId
        INNER JOIN
    parents T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId` = @srpcDT;
    
SET @srpcTemConf=(SELECT id FROM msg_template_config WHERE `code`='Service Request Parent Transfer Creation');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Your request for $recipientData[&quot;REQUEST_TYPE&quot;] is created with request number $recipientData[&quot;REQUEST_ID&quot;]. The Administrator will contact you shortly.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @srpcTemConf and msgDeliveryModeId in (1,4);



-- Service Request Assinee Creation


SET @sracDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_ASSINEE_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    (CASE WHEN T6.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN T6.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T6.logoUrl) END) AS LOGO_URL
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.assigneeId
        LEFT JOIN
    staffs T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId` = @sracDT;
    
SET @sracTemConf=(SELECT id FROM msg_template_config WHERE `code`='Service Request Assignee Creation');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Service Request for $recipientData[&quot;REQUEST_TYPE&quot;] with request number $recipientData[&quot;REQUEST_ID&quot;] is assigned to you.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @sracTemConf and msgDeliveryModeId in (1,4);


set sql_safe_updates=1;

